//
//  CRNSOptionalBoxBase.h
//  CRKit
//
//  Created by Yaroslav Glushchenko on 12/16/11.
//  Copyright 2011 Neatberry. All rights reserved.
//

#import "CRNSBoxBase.h"

//////////////////////////////////////////////////////////////////////
// Optional box overrides "Control Area" to create a custom checkbox
//////////////////////////////////////////////////////////////////////
@interface CRNSOptionalBoxBase : CRNSBoxBase
{
	BOOL pressed;
	BOOL status;
	BOOL enabled;
	
	NSColor* controlAreaColor;
	
@private
	CRTwoWayBindingManager* bindingManager;
}

@property (nonatomic, copy)	  NSColor*	controlAreaColor;
@property (nonatomic, assign) BOOL		status;
@property (nonatomic, assign) BOOL		enabled;

- (void)fillControlArea:(NSBezierPath *)path;

@end